<?php

/**
 * This is the model class for table "PunktyFirmy".
 *
 * The followings are the available columns in table 'PunktyFirmy':
 * @property double $idFirmy
 * @property double $punkty
 */
class PunktyFirmy extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PunktyFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function getPrimaryKey()
	{
		return 'idFirmy';
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'PunktyFirmy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idFirmy, punkty', 'numerical'),

			array('idFirmy, punkty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idFirmy'=>Yii::t('PunktyFirmy', 'idFirmy'),
			'punkty'=>Yii::t('PunktyFirmy', 'punkty'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('idFirmy', $this->idFirmy);
		$criteria->compare('punkty', $this->punkty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}